--------------------------------------------------------
-- Archivo creado  - mircoles-setiembre-18-2024   
--------------------------------------------------------
--------------------------------------------------------
--  DDL for Table CLIENTE
--------------------------------------------------------

  CREATE TABLE "CLIENTE" 
   (	"IDCLIENTE" VARCHAR2(8 BYTE), 
	"DNI" VARCHAR2(8 BYTE), 
	"NOMBRE" VARCHAR2(100 BYTE), 
	"APELLIDO" VARCHAR2(100 BYTE), 
	"SEXO" VARCHAR2(10 BYTE), 
	"FECHANACIMIENTO" DATE, 
	"DIRECCION" VARCHAR2(100 BYTE), 
	"TELEFONO" VARCHAR2(11 BYTE), 
	"EMAIL" VARCHAR2(100 BYTE), 
	"FECHAREGISTRO" TIMESTAMP (3) DEFAULT CURRENT_TIMESTAMP(3)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table CUENTA
--------------------------------------------------------

  CREATE TABLE "CUENTA" 
   (	"IDCUENTA" VARCHAR2(8 BYTE), 
	"IDCLIENTE" VARCHAR2(8 BYTE), 
	"TIPOCUENTA" VARCHAR2(10 BYTE) DEFAULT 'debito', 
	"ESTADO" VARCHAR2(10 BYTE) DEFAULT 'activa', 
	"SALDO" NUMBER(15,2) DEFAULT 0.00, 
	"FECHAAPERTURA" TIMESTAMP (3) DEFAULT CURRENT_TIMESTAMP(3), 
	"CONTRASEA" VARCHAR2(16 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table EMPLEADO
--------------------------------------------------------

  CREATE TABLE "EMPLEADO" 
   (	"IDEMPLEADO" VARCHAR2(8 BYTE), 
	"NOMBRE" VARCHAR2(100 BYTE), 
	"APELLIDO" VARCHAR2(100 BYTE), 
	"SEXO" VARCHAR2(10 BYTE), 
	"FECHANACIMIENTO" DATE, 
	"CARGO" VARCHAR2(15 BYTE), 
	"FECHACONTRATACION" DATE DEFAULT SYSDATE, 
	"SALARIO" NUMBER(15,2), 
	"CONTRASEA" VARCHAR2(8 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table TRANSACCION
--------------------------------------------------------

  CREATE TABLE "TRANSACCION" 
   (	"IDTRANSACCION" VARCHAR2(8 BYTE), 
	"IDCUENTA" VARCHAR2(8 BYTE), 
	"IDEMPLEADO" VARCHAR2(8 BYTE), 
	"TIPOTRANSACCION" VARCHAR2(255 BYTE), 
	"DESCRIPCION" VARCHAR2(255 BYTE), 
	"MONTO" NUMBER(15,2), 
	"FECHATRANSACCION" TIMESTAMP (3) DEFAULT CURRENT_TIMESTAMP(3), 
	"CUENTARECIBE" VARCHAR2(8 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
REM INSERTING into CLIENTE
SET DEFINE OFF;
Insert into CLIENTE (IDCLIENTE,DNI,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,DIRECCION,TELEFONO,EMAIL,FECHAREGISTRO) values ('BANK0001','BANK0001','BANK','PERU','otros',to_date('01/01/00','DD/MM/RR'),'NUEVO PERU BANCO','111111111','BANK@gmail.com',to_timestamp('08/09/24 12:00:00,000000000 AM','DD/MM/RR HH12:MI:SSXFF AM'));
Insert into CLIENTE (IDCLIENTE,DNI,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,DIRECCION,TELEFONO,EMAIL,FECHAREGISTRO) values ('CL000001','10000001','Juan','Prez','masculino',to_date('12/05/90','DD/MM/RR'),'Calle Falsa 123','9999999999','juan.perez@example.com',to_timestamp('17/09/24 07:20:37,251000000 PM','DD/MM/RR HH12:MI:SSXFF AM'));
Insert into CLIENTE (IDCLIENTE,DNI,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,DIRECCION,TELEFONO,EMAIL,FECHAREGISTRO) values ('CL000002','10000002','Ana','Lpez','femenino',to_date('23/10/85','DD/MM/RR'),'Av. Siempre Viva 456','9999999998','ana.lopez@example.com',to_timestamp('17/09/24 07:20:37,257000000 PM','DD/MM/RR HH12:MI:SSXFF AM'));
Insert into CLIENTE (IDCLIENTE,DNI,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,DIRECCION,TELEFONO,EMAIL,FECHAREGISTRO) values ('CL000003','10000003','Carlos','Gmez','masculino',to_date('17/07/92','DD/MM/RR'),'Calle Sol 789','9999999997','carlos.gomez@example.com',to_timestamp('17/09/24 07:20:37,261000000 PM','DD/MM/RR HH12:MI:SSXFF AM'));
Insert into CLIENTE (IDCLIENTE,DNI,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,DIRECCION,TELEFONO,EMAIL,FECHAREGISTRO) values ('CL000004','10000004','Luca','Martnez','femenino',to_date('22/03/95','DD/MM/RR'),'Av. Luna 321','9999999996','lucia.martinez@example.com',to_timestamp('17/09/24 07:20:37,265000000 PM','DD/MM/RR HH12:MI:SSXFF AM'));
Insert into CLIENTE (IDCLIENTE,DNI,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,DIRECCION,TELEFONO,EMAIL,FECHAREGISTRO) values ('CL000005','10000005','Pedro','Rodrguez','masculino',to_date('01/11/88','DD/MM/RR'),'Calle Ro 654','9999999995','pedro.rodriguez@example.com',to_timestamp('17/09/24 07:20:37,268000000 PM','DD/MM/RR HH12:MI:SSXFF AM'));
Insert into CLIENTE (IDCLIENTE,DNI,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,DIRECCION,TELEFONO,EMAIL,FECHAREGISTRO) values ('CL000006','10000006','Laura','Ramrez','femenino',to_date('15/09/94','DD/MM/RR'),'Av. Mar 987','9999999994','laura.ramirez@example.com',to_timestamp('17/09/24 07:20:37,271000000 PM','DD/MM/RR HH12:MI:SSXFF AM'));
Insert into CLIENTE (IDCLIENTE,DNI,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,DIRECCION,TELEFONO,EMAIL,FECHAREGISTRO) values ('CL000007','10000007','Jorge','Hernndez','masculino',to_date('04/08/91','DD/MM/RR'),'Calle Viento 213','9999999993','jorge.hernandez@example.com',to_timestamp('17/09/24 07:20:37,275000000 PM','DD/MM/RR HH12:MI:SSXFF AM'));
Insert into CLIENTE (IDCLIENTE,DNI,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,DIRECCION,TELEFONO,EMAIL,FECHAREGISTRO) values ('CL000008','10000008','Sofa','Moreno','femenino',to_date('25/06/93','DD/MM/RR'),'Av. Trueno 546','9999999992','sofia.moreno@example.com',to_timestamp('17/09/24 07:20:37,278000000 PM','DD/MM/RR HH12:MI:SSXFF AM'));
Insert into CLIENTE (IDCLIENTE,DNI,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,DIRECCION,TELEFONO,EMAIL,FECHAREGISTRO) values ('CL000009','10000009','David','Daz','masculino',to_date('12/12/87','DD/MM/RR'),'Calle Nube 879','9999999991','david.diaz@example.com',to_timestamp('17/09/24 07:20:37,281000000 PM','DD/MM/RR HH12:MI:SSXFF AM'));
Insert into CLIENTE (IDCLIENTE,DNI,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,DIRECCION,TELEFONO,EMAIL,FECHAREGISTRO) values ('CL000010','10000010','Marta','Jimnez','femenino',to_date('28/02/96','DD/MM/RR'),'Av. Rayo 102','9999999990','marta.jimenez@example.com',to_timestamp('17/09/24 07:20:37,285000000 PM','DD/MM/RR HH12:MI:SSXFF AM'));
Insert into CLIENTE (IDCLIENTE,DNI,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,DIRECCION,TELEFONO,EMAIL,FECHAREGISTRO) values ('CL000011','10000011','Fernando','Ruiz','masculino',to_date('30/01/92','DD/MM/RR'),'Calle Sol 109','9999999989','fernando.ruiz@example.com',to_timestamp('17/09/24 07:20:37,289000000 PM','DD/MM/RR HH12:MI:SSXFF AM'));
Insert into CLIENTE (IDCLIENTE,DNI,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,DIRECCION,TELEFONO,EMAIL,FECHAREGISTRO) values ('CL000012','10000012','Patricia','Prez','femenino',to_date('15/04/89','DD/MM/RR'),'Av. Tierra 505','9999999988','patricia.perez@example.com',to_timestamp('17/09/24 07:20:37,292000000 PM','DD/MM/RR HH12:MI:SSXFF AM'));
Insert into CLIENTE (IDCLIENTE,DNI,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,DIRECCION,TELEFONO,EMAIL,FECHAREGISTRO) values ('CL000013','10000013','Ral','Torres','masculino',to_date('20/07/90','DD/MM/RR'),'Calle Cielo 200','9999999987','raul.torres@example.com',to_timestamp('17/09/24 07:20:37,296000000 PM','DD/MM/RR HH12:MI:SSXFF AM'));
Insert into CLIENTE (IDCLIENTE,DNI,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,DIRECCION,TELEFONO,EMAIL,FECHAREGISTRO) values ('CL000014','10000014','Gabriela','Vega','femenino',to_date('03/11/93','DD/MM/RR'),'Av. Lluvia 319','9999999986','gabriela.vega@example.com',to_timestamp('17/09/24 07:20:37,299000000 PM','DD/MM/RR HH12:MI:SSXFF AM'));
Insert into CLIENTE (IDCLIENTE,DNI,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,DIRECCION,TELEFONO,EMAIL,FECHAREGISTRO) values ('CL000015','10000015','Luis','Castro','masculino',to_date('25/09/91','DD/MM/RR'),'Calle Sol 728','9999999985','luis.castro@example.com',to_timestamp('17/09/24 07:20:37,302000000 PM','DD/MM/RR HH12:MI:SSXFF AM'));
Insert into CLIENTE (IDCLIENTE,DNI,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,DIRECCION,TELEFONO,EMAIL,FECHAREGISTRO) values ('CL000016','10000016','Alejandra','Gonzlez','femenino',to_date('16/05/95','DD/MM/RR'),'Av. Luna 142','9999999984','alejandra.gonzalez@example.com',to_timestamp('17/09/24 07:20:37,306000000 PM','DD/MM/RR HH12:MI:SSXFF AM'));
Insert into CLIENTE (IDCLIENTE,DNI,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,DIRECCION,TELEFONO,EMAIL,FECHAREGISTRO) values ('CL000017','10000017','Toms','Flores','masculino',to_date('11/12/94','DD/MM/RR'),'Calle Sol 309','9999999983','tomas.flores@example.com',to_timestamp('17/09/24 07:20:37,309000000 PM','DD/MM/RR HH12:MI:SSXFF AM'));
Insert into CLIENTE (IDCLIENTE,DNI,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,DIRECCION,TELEFONO,EMAIL,FECHAREGISTRO) values ('CL000018','10000018','Valeria','Ortega','femenino',to_date('01/10/90','DD/MM/RR'),'Av. Mar 654','9999999982','valeria.ortega@example.com',to_timestamp('17/09/24 07:20:37,313000000 PM','DD/MM/RR HH12:MI:SSXFF AM'));
Insert into CLIENTE (IDCLIENTE,DNI,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,DIRECCION,TELEFONO,EMAIL,FECHAREGISTRO) values ('CL000019','10000019','Emilio','Navarro','masculino',to_date('22/06/92','DD/MM/RR'),'Calle Ro 789','9999999981','emilio.navarro@example.com',to_timestamp('17/09/24 07:20:37,317000000 PM','DD/MM/RR HH12:MI:SSXFF AM'));
Insert into CLIENTE (IDCLIENTE,DNI,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,DIRECCION,TELEFONO,EMAIL,FECHAREGISTRO) values ('CL000020','10000020','Elena','Mendoza','femenino',to_date('14/08/91','DD/MM/RR'),'Av. Fuego 910','9999999980','elena.mendoza@example.com',to_timestamp('17/09/24 07:20:37,322000000 PM','DD/MM/RR HH12:MI:SSXFF AM'));
REM INSERTING into CUENTA
SET DEFINE OFF;
Insert into CUENTA (IDCUENTA,IDCLIENTE,TIPOCUENTA,ESTADO,SALDO,FECHAAPERTURA,"CONTRASEA") values ('00001DEP','BANK0001','credito','activa','0',to_timestamp('08/09/24 12:00:00,000000000 AM','DD/MM/RR HH12:MI:SSXFF AM'),'deposito');
Insert into CUENTA (IDCUENTA,IDCLIENTE,TIPOCUENTA,ESTADO,SALDO,FECHAAPERTURA,"CONTRASEA") values ('00001RET','BANK0001','credito','activa','0',to_timestamp('09/09/24 12:00:00,000000000 AM','DD/MM/RR HH12:MI:SSXFF AM'),'retiro');
Insert into CUENTA (IDCUENTA,IDCLIENTE,TIPOCUENTA,ESTADO,SALDO,FECHAAPERTURA,"CONTRASEA") values ('30000001','CL000001','debito','activa','1000',to_timestamp('17/09/24 07:48:07,977000000 PM','DD/MM/RR HH12:MI:SSXFF AM'),'12345678');
Insert into CUENTA (IDCUENTA,IDCLIENTE,TIPOCUENTA,ESTADO,SALDO,FECHAAPERTURA,"CONTRASEA") values ('30000002','CL000002','debito','activa','1000',to_timestamp('17/09/24 07:48:07,980000000 PM','DD/MM/RR HH12:MI:SSXFF AM'),'12345678');
Insert into CUENTA (IDCUENTA,IDCLIENTE,TIPOCUENTA,ESTADO,SALDO,FECHAAPERTURA,"CONTRASEA") values ('30000003','CL000003','debito','activa','1000',to_timestamp('17/09/24 07:48:07,983000000 PM','DD/MM/RR HH12:MI:SSXFF AM'),'12345678');
Insert into CUENTA (IDCUENTA,IDCLIENTE,TIPOCUENTA,ESTADO,SALDO,FECHAAPERTURA,"CONTRASEA") values ('30000004','CL000004','debito','activa','1000',to_timestamp('17/09/24 07:48:07,986000000 PM','DD/MM/RR HH12:MI:SSXFF AM'),'12345678');
Insert into CUENTA (IDCUENTA,IDCLIENTE,TIPOCUENTA,ESTADO,SALDO,FECHAAPERTURA,"CONTRASEA") values ('30000005','CL000005','debito','activa','1000',to_timestamp('17/09/24 07:48:07,988000000 PM','DD/MM/RR HH12:MI:SSXFF AM'),'12345678');
Insert into CUENTA (IDCUENTA,IDCLIENTE,TIPOCUENTA,ESTADO,SALDO,FECHAAPERTURA,"CONTRASEA") values ('30000006','CL000006','debito','activa','1000',to_timestamp('17/09/24 07:48:07,992000000 PM','DD/MM/RR HH12:MI:SSXFF AM'),'12345678');
Insert into CUENTA (IDCUENTA,IDCLIENTE,TIPOCUENTA,ESTADO,SALDO,FECHAAPERTURA,"CONTRASEA") values ('30000007','CL000007','debito','activa','1000',to_timestamp('17/09/24 07:48:07,997000000 PM','DD/MM/RR HH12:MI:SSXFF AM'),'12345678');
Insert into CUENTA (IDCUENTA,IDCLIENTE,TIPOCUENTA,ESTADO,SALDO,FECHAAPERTURA,"CONTRASEA") values ('30000008','CL000008','debito','activa','1000',to_timestamp('17/09/24 07:48:08,000000000 PM','DD/MM/RR HH12:MI:SSXFF AM'),'12345678');
Insert into CUENTA (IDCUENTA,IDCLIENTE,TIPOCUENTA,ESTADO,SALDO,FECHAAPERTURA,"CONTRASEA") values ('30000009','CL000009','debito','activa','1000',to_timestamp('17/09/24 07:48:08,003000000 PM','DD/MM/RR HH12:MI:SSXFF AM'),'12345678');
Insert into CUENTA (IDCUENTA,IDCLIENTE,TIPOCUENTA,ESTADO,SALDO,FECHAAPERTURA,"CONTRASEA") values ('30000010','CL000010','debito','activa','1000',to_timestamp('17/09/24 07:48:08,006000000 PM','DD/MM/RR HH12:MI:SSXFF AM'),'12345678');
Insert into CUENTA (IDCUENTA,IDCLIENTE,TIPOCUENTA,ESTADO,SALDO,FECHAAPERTURA,"CONTRASEA") values ('30000011','CL000011','debito','activa','1000',to_timestamp('17/09/24 07:48:08,009000000 PM','DD/MM/RR HH12:MI:SSXFF AM'),'12345678');
Insert into CUENTA (IDCUENTA,IDCLIENTE,TIPOCUENTA,ESTADO,SALDO,FECHAAPERTURA,"CONTRASEA") values ('30000012','CL000012','debito','activa','1000',to_timestamp('17/09/24 07:48:08,013000000 PM','DD/MM/RR HH12:MI:SSXFF AM'),'12345678');
Insert into CUENTA (IDCUENTA,IDCLIENTE,TIPOCUENTA,ESTADO,SALDO,FECHAAPERTURA,"CONTRASEA") values ('30000013','CL000013','debito','activa','1000',to_timestamp('17/09/24 07:48:08,016000000 PM','DD/MM/RR HH12:MI:SSXFF AM'),'12345678');
Insert into CUENTA (IDCUENTA,IDCLIENTE,TIPOCUENTA,ESTADO,SALDO,FECHAAPERTURA,"CONTRASEA") values ('30000014','CL000014','debito','activa','1000',to_timestamp('17/09/24 07:48:08,019000000 PM','DD/MM/RR HH12:MI:SSXFF AM'),'12345678');
Insert into CUENTA (IDCUENTA,IDCLIENTE,TIPOCUENTA,ESTADO,SALDO,FECHAAPERTURA,"CONTRASEA") values ('30000015','CL000015','debito','activa','1000',to_timestamp('17/09/24 07:48:08,022000000 PM','DD/MM/RR HH12:MI:SSXFF AM'),'12345678');
Insert into CUENTA (IDCUENTA,IDCLIENTE,TIPOCUENTA,ESTADO,SALDO,FECHAAPERTURA,"CONTRASEA") values ('30000016','CL000016','debito','activa','1000',to_timestamp('17/09/24 07:48:08,026000000 PM','DD/MM/RR HH12:MI:SSXFF AM'),'12345678');
Insert into CUENTA (IDCUENTA,IDCLIENTE,TIPOCUENTA,ESTADO,SALDO,FECHAAPERTURA,"CONTRASEA") values ('30000017','CL000017','debito','activa','1000',to_timestamp('17/09/24 07:48:08,029000000 PM','DD/MM/RR HH12:MI:SSXFF AM'),'12345678');
Insert into CUENTA (IDCUENTA,IDCLIENTE,TIPOCUENTA,ESTADO,SALDO,FECHAAPERTURA,"CONTRASEA") values ('30000018','CL000018','debito','activa','1000',to_timestamp('17/09/24 07:48:08,033000000 PM','DD/MM/RR HH12:MI:SSXFF AM'),'12345678');
Insert into CUENTA (IDCUENTA,IDCLIENTE,TIPOCUENTA,ESTADO,SALDO,FECHAAPERTURA,"CONTRASEA") values ('30000019','CL000019','debito','activa','1000',to_timestamp('17/09/24 07:48:08,036000000 PM','DD/MM/RR HH12:MI:SSXFF AM'),'12345678');
Insert into CUENTA (IDCUENTA,IDCLIENTE,TIPOCUENTA,ESTADO,SALDO,FECHAAPERTURA,"CONTRASEA") values ('30000020','CL000020','debito','activa','1000',to_timestamp('17/09/24 07:48:08,039000000 PM','DD/MM/RR HH12:MI:SSXFF AM'),'12345678');
REM INSERTING into EMPLEADO
SET DEFINE OFF;
Insert into EMPLEADO (IDEMPLEADO,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,CARGO,FECHACONTRATACION,SALARIO,"CONTRASEA") values ('WEB00001','Banca Movil','Banca','otros',to_date('31/08/24','DD/MM/RR'),'cajero',to_date('31/08/24','DD/MM/RR'),'0',null);
Insert into EMPLEADO (IDEMPLEADO,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,CARGO,FECHACONTRATACION,SALARIO,"CONTRASEA") values ('EMP00002','Ana','Gmez','femenino',to_date('22/07/90','DD/MM/RR'),'cajero',to_date('17/09/24','DD/MM/RR'),'1500','12345678');
Insert into EMPLEADO (IDEMPLEADO,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,CARGO,FECHACONTRATACION,SALARIO,"CONTRASEA") values ('EMP00003','Carlos','Lpez','masculino',to_date('30/09/78','DD/MM/RR'),'asesor',to_date('17/09/24','DD/MM/RR'),'2500','12345678');
Insert into EMPLEADO (IDEMPLEADO,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,CARGO,FECHACONTRATACION,SALARIO,"CONTRASEA") values ('EMP00004','Laura','Martnez','femenino',to_date('15/03/82','DD/MM/RR'),'administrador',to_date('17/09/24','DD/MM/RR'),'3000','12345678');
Insert into EMPLEADO (IDEMPLEADO,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,CARGO,FECHACONTRATACION,SALARIO,"CONTRASEA") values ('EMP00005','Sergio','Rodrguez','otros',to_date('05/11/95','DD/MM/RR'),'asesor',to_date('17/09/24','DD/MM/RR'),'2200','12345678');
Insert into EMPLEADO (IDEMPLEADO,NOMBRE,APELLIDO,SEXO,FECHANACIMIENTO,CARGO,FECHACONTRATACION,SALARIO,"CONTRASEA") values ('EMP00001','Juan','Prez','masculino',to_date('10/05/85','DD/MM/RR'),'gerente',to_date('17/09/24','DD/MM/RR'),'3500','12345678');
REM INSERTING into TRANSACCION
SET DEFINE OFF;
--------------------------------------------------------
--  DDL for Index SYS_C008389
--------------------------------------------------------

  CREATE UNIQUE INDEX "SYS_C008389" ON "CLIENTE" ("IDCLIENTE") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index SYS_C008394
--------------------------------------------------------

  CREATE UNIQUE INDEX "SYS_C008394" ON "CUENTA" ("IDCUENTA") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index SYS_C008404
--------------------------------------------------------

  CREATE UNIQUE INDEX "SYS_C008404" ON "EMPLEADO" ("IDEMPLEADO") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index SYS_C008409
--------------------------------------------------------

  CREATE UNIQUE INDEX "SYS_C008409" ON "TRANSACCION" ("IDTRANSACCION") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index SYS_C008389
--------------------------------------------------------

  CREATE UNIQUE INDEX "SYS_C008389" ON "CLIENTE" ("IDCLIENTE") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index SYS_C008394
--------------------------------------------------------

  CREATE UNIQUE INDEX "SYS_C008394" ON "CUENTA" ("IDCUENTA") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index SYS_C008404
--------------------------------------------------------

  CREATE UNIQUE INDEX "SYS_C008404" ON "EMPLEADO" ("IDEMPLEADO") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index SYS_C008409
--------------------------------------------------------

  CREATE UNIQUE INDEX "SYS_C008409" ON "TRANSACCION" ("IDTRANSACCION") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  Constraints for Table CLIENTE
--------------------------------------------------------

  ALTER TABLE "CLIENTE" MODIFY ("IDCLIENTE" NOT NULL ENABLE);
  ALTER TABLE "CLIENTE" MODIFY ("NOMBRE" NOT NULL ENABLE);
  ALTER TABLE "CLIENTE" MODIFY ("APELLIDO" NOT NULL ENABLE);
  ALTER TABLE "CLIENTE" MODIFY ("SEXO" NOT NULL ENABLE);
  ALTER TABLE "CLIENTE" MODIFY ("FECHANACIMIENTO" NOT NULL ENABLE);
  ALTER TABLE "CLIENTE" MODIFY ("DIRECCION" NOT NULL ENABLE);
  ALTER TABLE "CLIENTE" ADD CONSTRAINT "CHK_SEXO" CHECK (sexo IN ('femenino','masculino','otros')) ENABLE;
  ALTER TABLE "CLIENTE" ADD PRIMARY KEY ("IDCLIENTE")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table CUENTA
--------------------------------------------------------

  ALTER TABLE "CUENTA" MODIFY ("IDCUENTA" NOT NULL ENABLE);
  ALTER TABLE "CUENTA" MODIFY ("IDCLIENTE" NOT NULL ENABLE);
  ALTER TABLE "CUENTA" ADD CONSTRAINT "CHK_ESTADO" CHECK (estado IN ('activa', 'inactiva', 'cerrado')) ENABLE;
  ALTER TABLE "CUENTA" ADD CONSTRAINT "CHK_TIPOCUENTA" CHECK (tipoCuenta IN ('debito','credito')) ENABLE;
  ALTER TABLE "CUENTA" ADD PRIMARY KEY ("IDCUENTA")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "CUENTA" MODIFY ("CONTRASEA" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table EMPLEADO
--------------------------------------------------------

  ALTER TABLE "EMPLEADO" MODIFY ("IDEMPLEADO" NOT NULL ENABLE);
  ALTER TABLE "EMPLEADO" MODIFY ("NOMBRE" NOT NULL ENABLE);
  ALTER TABLE "EMPLEADO" MODIFY ("APELLIDO" NOT NULL ENABLE);
  ALTER TABLE "EMPLEADO" MODIFY ("FECHANACIMIENTO" NOT NULL ENABLE);
  ALTER TABLE "EMPLEADO" MODIFY ("FECHACONTRATACION" NOT NULL ENABLE);
  ALTER TABLE "EMPLEADO" MODIFY ("SALARIO" NOT NULL ENABLE);
  ALTER TABLE "EMPLEADO" ADD CONSTRAINT "CHK_CARGO" CHECK (cargo IN ('gerente', 'cajero', 'asesor', 'administrador')) ENABLE;
  ALTER TABLE "EMPLEADO" ADD CONSTRAINT "CHK_SEXO_EMPLEADO" CHECK (sexo IN ('masculino', 'femenino', 'otros')) ENABLE;
  ALTER TABLE "EMPLEADO" ADD PRIMARY KEY ("IDEMPLEADO")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table TRANSACCION
--------------------------------------------------------

  ALTER TABLE "TRANSACCION" MODIFY ("IDTRANSACCION" NOT NULL ENABLE);
  ALTER TABLE "TRANSACCION" MODIFY ("IDCUENTA" NOT NULL ENABLE);
  ALTER TABLE "TRANSACCION" MODIFY ("MONTO" NOT NULL ENABLE);
  ALTER TABLE "TRANSACCION" ADD CONSTRAINT "CHK_TIPOTRANSACCION" CHECK (tipoTransaccion IN ('Deposito', 'Retiro', 'Transferencia', 'Pago')) ENABLE;
  ALTER TABLE "TRANSACCION" ADD PRIMARY KEY ("IDTRANSACCION")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "TRANSACCION" MODIFY ("CUENTARECIBE" NOT NULL ENABLE);
--------------------------------------------------------
--  Ref Constraints for Table CUENTA
--------------------------------------------------------

  ALTER TABLE "CUENTA" ADD CONSTRAINT "FK_CLIENTE_CUENTA" FOREIGN KEY ("IDCLIENTE")
	  REFERENCES "CLIENTE" ("IDCLIENTE") ON DELETE CASCADE ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table TRANSACCION
--------------------------------------------------------

  ALTER TABLE "TRANSACCION" ADD CONSTRAINT "FK_TRANSACCION_CUENTA" FOREIGN KEY ("IDCUENTA")
	  REFERENCES "CUENTA" ("IDCUENTA") ON DELETE CASCADE ENABLE;
  ALTER TABLE "TRANSACCION" ADD CONSTRAINT "FK_TRANSACCION_CUENTARECIBE" FOREIGN KEY ("CUENTARECIBE")
	  REFERENCES "CUENTA" ("IDCUENTA") ON DELETE CASCADE ENABLE;
  ALTER TABLE "TRANSACCION" ADD CONSTRAINT "FK_TRANSACCION_EMPLEADO" FOREIGN KEY ("IDEMPLEADO")
	  REFERENCES "EMPLEADO" ("IDEMPLEADO") ON DELETE CASCADE ENABLE;
